/* $Id: source3.c,v 1.9 1998/07/22 20:58:30 ericb Exp $ */
/* Copyright (C) 1997 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Eric Backus */

/* The source to be tested must be in module with LA of 8 and
   sema.bin must be installed into module 8 before running this program */

#include <stdio.h>		/* For printf */
#include <stdlib.h>		/* For exit */
#include "e1432.h"

/* Wrap this around all the many function calls which might fail */
#ifdef	__lint
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	(void) fprintf(stderr, "Error: %s returned %d\n", #func, _s);\
	return _s;\
    }\
} while (func)
#else
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	(void) fprintf(stderr, "Error: %s returned %d\n", #func, _s);\
	return _s;\
    }\
} while (0)
#endif

int
main(void)
{
    struct e1432_hwconfig hwconfig;
    int     nsource;
    SHORTSIZ16 gsource;
    SHORTSIZ16 lsource[1];
    SHORTSIZ16 laddr = 8;
    E1432ID hw;

    /* Initialize library things */
    CHECK(e1432_init_io_driver());
    CHECK(e1432_print_errors(1));
    CHECK(e1432_assign_channel_numbers(1, &laddr, &hw));

    /* Create channel group */
    CHECK(e1432_get_hwconfig(1, &laddr, &hwconfig));
    if (hwconfig.source_chans == 0)
    {
	(void) fprintf(stderr, "No source found!\n");
	return 2;
    }
    nsource = 1;
    lsource[0] = E1432_SOURCE_CHAN(1);
    gsource = e1432_create_channel_group(hw, nsource, lsource);
    if (gsource >= 0)
    {
	(void) fprintf(stderr, "e1432_create_channel_group returned %d\n",
		       gsource);
	return 2;
    }

    /* 5 Volt, 5 KHz sine, 6.4 KHz filter, with SUM input on */
    CHECK(e1432_set_active(hw, gsource, E1432_CHANNEL_ON));
    CHECK(e1432_set_source_mode(hw, gsource, E1432_SOURCE_MODE_BRAND));
    CHECK(e1432_set_duty_cycle(hw, gsource, 0.9));
    CHECK(e1432_set_range(hw, gsource, 10));
    CHECK(e1432_set_amp_scale(hw, gsource, 0.5));
    CHECK(e1432_set_filter_freq(hw, gsource, 6400));
    CHECK(e1432_set_ramp_rate(hw, gsource, 0.0));
    CHECK(e1432_set_source_seed(hw, gsource, 0xff));
    CHECK(e1432_set_auto_trigger(hw, gsource, E1432_MANUAL_TRIGGER));
    CHECK(e1432_set_trigger_channel(hw, gsource, E1432_CHANNEL_ON));

    /* Auto-zero the source */

    /* Normally, you could just call e1432_auto_zero(hw, gsource), and
       that would be sufficient.

       However, if the filter frequency programmed into the source
       channels changes, this is not sufficient.

       We set the filter frequency to 6400, rather than the default
       25600, so we must follow the more complicated procedure
       auto-zero the source.  First, set the source output mode to
       grounded.  This prevents any glitching at the source BNC, but
       it causes the source to drive the module's CALOUT line.  Then,
       set the source arm mode to manual, so the source never really
       starts, so all we drive onto the CALOUT line is DC.  Then, set
       the module to not drive CALOUT onto the VXI sumbus, so we can't
       accidentally mess up anyone else's use of the VXI sumbus.  Then
       start and stop a measurement.  This gets the correct signal
       path loaded into the source, without glitching the output.
       Then do the auto-zero, then restore the sumbus setting, the
       source output mode, and the arm mode.

       You could do this procedure for all auto-zeros, even when the
       filter frequency does not change.  It takes a little longer,
       though. */

    /* Set manual arm, output grounded, sumbus off */
    CHECK(e1432_set_arm_mode(hw, gsource, E1432_MANUAL_ARM));
    CHECK(e1432_set_source_output(hw, gsource, E1432_SOURCE_OUTPUT_GROUNDED));
    CHECK(e1432_set_sumbus(hw, gsource, E1432_SUMBUS_OFF));
    /* Start and stop measurement, then auto-zero */
    CHECK(e1432_init_measure(hw, gsource));
    CHECK(e1432_reset_measure(hw, gsource));
    CHECK(e1432_auto_zero(hw, gsource));
    /* Restore desired sumbus, output, and arm settings */
    CHECK(e1432_set_sumbus(hw, gsource, E1432_SUMBUS_OFF));
    CHECK(e1432_set_source_output(hw, gsource, E1432_SOURCE_OUTPUT_NORMAL));
    CHECK(e1432_set_arm_mode(hw, gsource, E1432_AUTO_ARM));

    /* Start measurement, which also starts the source */
    CHECK(e1432_init_measure(hw, gsource));
#if 0
    while (1)
	CHECK(e1432_trigger_measure(hw, gsource, 1));
    /*NOTREACHED*/
#endif

    return 0;
}
